<?php
include_once "../class/classes.php";
$xml= simplexml_load_file("../languages/arrent.xml") or die("XML not found");
$gllang = $_POST['lang'];
// Funkcija za pretvaranje datuma u format m-d
function formatDate($date) {
    return $date->format('m-d');
}

// Definisanje cenovnika
$cenovnici = [
    'prvi' => [['01-08', '03-28'], ['11-01', '12-22']],
    'drugi' => [['03-29', '04-17'], ['05-03', '06-15'], ['09-01', '10-31']],
    'treci' => [['04-18', '05-02'], ['06-16', '07-14'], ['08-11', '08-31'], ['12-23', '01-07']],
    'cetvrti' => [['07-15', '08-10']]
];

// Funkcija za proveru da li datum pripada periodu
function isInRange($date, $range) {

    $currentYear = date('Y');

// Menjamo godinu na trenutnu, dok ostavljamo isti mesec i dan
    $date->setDate($currentYear, $date->format('m'), $date->format('d'));

    $start = DateTime::createFromFormat('m-d', $range[0]);
    $end = DateTime::createFromFormat('m-d', $range[1]);

    if ($start <= $end) {
        return $date >= $start && $date <= $end;
    } else {
        // Period prelazi preko godine (npr. 12-23 do 01-07)
        return ($date >= $start && $date <= DateTime::createFromFormat('m-d', '12-31')) || ($date >= DateTime::createFromFormat('m-d', '01-01') && $date <= $end);
    }
}




// Dobijanje vremenskog perioda iz POST zahteva
$daterange = explode(" - ", $_POST['daterange']);
$prvidan = DateTime::createFromFormat('d.m.Y', $daterange[0]);
$poslednjidan = DateTime::createFromFormat('d.m.Y', $daterange[1]);
$poslednjidan->modify('-1 day');

// Dobijanje vremena preuzimanja i vraćanja iz POST zahteva
$vremepreuzimanja = DateTime::createFromFormat('H:i', $_POST['vremepreuzimanja']);
$vremevracanja = DateTime::createFromFormat('H:i', $_POST['vremevracanja']);

if ($vremevracanja->getTimestamp() - $vremepreuzimanja->getTimestamp() >= 2 * 60 * 60) {
    $poslednjidan->modify('+1 day');
}

// Inicijalizacija brojača za svaki cenovnik
$counts = [
    'prvi' => 0,
    'drugi' => 0,
    'treci' => 0,
    'cetvrti' => 0
];

// Iteracija kroz svaku noć u unetom vremenskom periodu
$interval = DateInterval::createFromDateString('1 day');
$period = new DatePeriod($prvidan, $interval, $poslednjidan->modify('+1 day'));


foreach ($period as $date) {
    $formattedDate = formatDate($date);
    foreach ($cenovnici as $cenovnik => $ranges) {
        foreach ($ranges as $range) {
            if (isInRange($date, $range)) {
                $counts[$cenovnik]++;
                break 2; // Prelazimo na sledeći datum
            }
        }
    }
}

// Ako je razlika u danima jedan, postavi broj noći na 1
if ($prvidan == $poslednjidan) {
    foreach ($cenovnici as $cenovnik => $ranges) {
        foreach ($ranges as $range) {
            if (isInRange($prvidan, $range)) {
                $counts[$cenovnik] = 1;
                break 2; // Prelazimo na sledeći cenovnik
            }
        }
    }
}
$ukdana = 0;
// Ispis rezultata
foreach ($counts as $cenovnik => $count) {
    $ukdana+=$count;
    // echo "Broj noći u $cenovnik cenovniku: $count\n";
}

$string="";

if($ukdana==1){
    $string="_1";
}
elseif ($ukdana>1 && $ukdana<=3){
    $string="_2";
}
elseif ($ukdana>3 && $ukdana<=6){
    $string="_3";
}
elseif ($ukdana>6 && $ukdana<=10){
    $string="_4";
}
elseif ($ukdana>10 && $ukdana<=15){
    $string="_5";
}
elseif ($ukdana>15){
    $string="_6";
}

$db = new DBConfig();
$db -> config();
$db -> conn();

$query="SELECT * FROM cars WHERE id=".$_POST['car'];
$db->queryDB($query);
$row=$db->selectDB();

$ukcena = 0;


$mestopreuzimanja=$_POST['mestopreuzimanja'];
$mestovracanja=$_POST['mestovracanja'];

if($_POST['mestopreuzimanja']!="Aerodrom Beograd"){
    $ukcena+=20;
}

if($_POST['mestovracanja']!="Aerodrom Beograd"){
    $ukcena+=20;
}

foreach ($counts as $cenovnik => $count) {

    if($count!=0){
        if($cenovnik=="prvi"){
            $ukcena+=($row["cena1".$string] * $count);
        }
        if($cenovnik=="drugi"){
            $ukcena+=($row["cena2".$string] * $count);
        }
        if($cenovnik=="treci"){
            $ukcena+=($row["cena3".$string] * $count);
        }
        if($cenovnik=="cetvrti"){
            $ukcena+=($row["cena4".$string] * $count);
        }
    }
}


$dodaci = $_POST['dodaci'];


$fullosiguranje = $row['fullosiguranje'];

$ukdodaci = 0;


if (in_array("fullosiguranje", $dodaci)) {

    //fullosiguranje
    if($ukdana>=15){
        $ukdodaci+=15*$fullosiguranje;
    }
    else{
        $ukdodaci+=$ukdana*$fullosiguranje;
    }
}

if (in_array("premiumosiguranje", $dodaci)) {
    $ukdodaci+=10;
}

if (in_array("premiumosiguranje", $dodaci)) {
    $ukdodaci+=10;
}
if (in_array("gps", $dodaci)) {
    $ukdodaci+=$ukdana*6;
}
if (in_array("wifi", $dodaci)) {
    $ukdodaci+=$ukdana*5;
}
if (in_array("sedistazadecu1", $dodaci)) {
    //Sedista se obracunava 3e po danu max 12 dana, samo za skuplje dane
    if($ukdana>=10){
        $ukdodaci+=(10*3);
    }
    else if($ukdana>0 && $ukdana<10){
        $ukdodaci+=($ukdana*3);
    }
}
if (in_array("sedistazadecu2", $dodaci)) {
    //Sedista se obracunava 3e po danu max 12 dana, samo za skuplje dane
    if($ukdana>=10){
        $ukdodaci+=(10*3);
    }
    else if($ukdana>0 && $ukdana<10){
        $ukdodaci+=($ukdana*3);
    }
}
if (in_array("sedistazadecu3", $dodaci)) {
    //Sedista se obracunava 3e po danu max 12 dana, samo za skuplje dane
    if($ukdana>=10){
        $ukdodaci+=(10*3);
    }
    else if($ukdana>0 && $ukdana<10){
        $ukdodaci+=($ukdana*3);
    }
}
if (in_array("decijibooster", $dodaci)) {
    $ukdodaci+=0;
}
if (in_array("izlazakizzemlje", $dodaci)) {
    $ukdodaci+=40;
}
if (in_array("zelenikarton", $dodaci)) {
    $ukdodaci+=30;
}
if (in_array("dodatnivozac", $dodaci)) {
    //dodatni vozac se naplacuje 25 evra po najmu
    $ukdodaci+=25;
}


$ukvozilo = $ukcena;
$sveukupno = $ukdodaci+$ukvozilo;
?>
<p><strong><?=$xml->ukupnododaci->$gllang;?></strong>: <?=$ukdodaci;?>€</p>
<p><strong><?=$xml->ukupnovozilo->$gllang;?></strong>: <span style="color: red; text-decoration: line-through;"><?=round($ukvozilo*1.2);?>€</span> <?=$ukvozilo;?>€</p>
<p class="ukupno"><strong><?=$xml->ukupno->$gllang;?></strong>: <?=$sveukupno;?>€</p>
<p style="font-size: 14px; margin-bottom: 10px; margin-top: 5px;"><strong><?=$xml->deposite->$gllang;?></strong>: <?=$row['depozit'];?>€ <?=$xml->depositeinfovalute->$gllang;?></p>
<div style="background: white;
    padding: 10px;
    margin-bottom: 10px;"> <h6 style="font-size: 20px;"><i class='fa fa-percent' style='color:green'>%</i> <?=$xml->najboljacena->$gllang;?></h6><p><?=$xml->najboljacenainfo->$gllang;?></p></div><span style='font-size: 13px!important;'><?=$xml->ponuda->$gllang;?></span>